<?php
if (PHP_SAPI == 'cli')
  die('Se visualiza solamente desde un navegador.');
require_once dirname(__FILE__) . '/../../libreriasphp/phpexcel/Classes/PHPExcel.php';
date_default_timezone_set('America/Lima');
session_start();
require_once ("../../config/Cado.php");
require_once ("../stockvalorizado/cStockvalorizado.php");
$oStockvalorizado = new cStockvalorizado();
require_once ("../preciogestion/cPreciogestion.php");
$oPreciogestion = new cPreciogestion();
require_once ("../formatos/formato.php");


$fec = date('Y-m-d');
require_once ("../formatos/formato.php");
require_once ("../formatos/fechas.php");
// Create new PHPExcel object
$objPHPExcel = new PHPExcel();
// Set document properties
$objPHPExcel->getProperties()->setCreator("https://infosisperu.com")
->setLastModifiedBy("https://infosisperu.com")
->setTitle("REPORTE DE STOCK VALORIZADO")
->setSubject("Reporte")
->setDescription("Reporte generado por https://infosisperu.com")
->setKeywords("")
->setCategory("reporte excel");
$objPHPExcel->setActiveSheetIndex(0);
$c=1;
$estiloTituloColumnas = array(
  'font' => array(
    'name'  => 'Arial',
    'bold'  => true,
    'size'  =>8,
    'color' => array(
      'rgb' => '000000'
      )
    ),
  'fill' => array(
    'type'  => PHPExcel_Style_Fill::FILL_SOLID,
    'color' => array(
      'rgb' => 'FAFAFA')
    ),
  'borders' => array(
    'outline' => array(
      'style' => PHPExcel_Style_Border::BORDER_THIN ,
      'color' => array(
        'rgb' => '143860'
        )
      )
    ),
  'alignment' =>  array(
    'horizontal'=> PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    'vertical'  => PHPExcel_Style_Alignment::VERTICAL_CENTER,
    'wrap'      => TRUE
    )
  );
  
  $estiloTitulos = array(
  'font' => array(
    'name'  => 'Arial',
    'bold'  => true,
    'size'  =>8,
    'color' => array(
      'rgb' => 'FFFFFF'
      )
    ),
  'fill' => array(
    'type'  => PHPExcel_Style_Fill::FILL_SOLID,
    'color' => array(
      'rgb' => 'FF8800')
    ),
  'borders' => array(
    'outline' => array(
      'style' => PHPExcel_Style_Border::BORDER_THIN ,
      'color' => array(
        'rgb' => '143860'
        )
      )
    ),
  'alignment' =>  array(
    'horizontal'=> PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    'vertical'  => PHPExcel_Style_Alignment::VERTICAL_CENTER,
    'wrap'      => TRUE
    )
  );
  
  $estiloTotales = array(
  'font' => array(
    'name'  => 'Arial',
    'bold'  => true,
    'size'  =>8,
    'color' => array(
      'rgb' => 'FFFFFF'
      )
    ),
  'fill' => array(
    'type'  => PHPExcel_Style_Fill::FILL_SOLID,
    'color' => array(
      'rgb' => '0d47a1')
    ),
  'borders' => array(
    'outline' => array(
      'style' => PHPExcel_Style_Border::BORDER_THIN ,
      'color' => array(
        'rgb' => '143860'
        )
      )
    ),
  'alignment' =>  array(
    'horizontal'=> PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    'vertical'  => PHPExcel_Style_Alignment::VERTICAL_CENTER,
    'wrap'      => TRUE
    )
  );
  
  $titulos = array(
  'NOMBRE',
  'LABORATORIO',
  'EMPAQUE',
  'PRECIO COSTO', 
  'STOCK',
  'VALORIZADO COSTO'
  );
  
  $letras = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');
  
	$objPHPExcel->getActiveSheet()->setCellValue("A$c", 'REPORTE DE STOCK VALORIZADO');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:G$c")->applyFromArray($estiloTitulos);
	
	$c = $c+1;
  
  $letracolumn = 0;
  
  //// COMPRAS
  for ($i=0; $i < count($titulos) ; $i++) { 
    $letracolumn = $i;
    $objPHPExcel->getActiveSheet()->setCellValue($letras[$i].$c, $titulos[$i]);
  }
  $objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->applyFromArray($estiloTituloColumnas);
		$c = $c+1;
 $dts1=$oStockvalorizado->filtrar($_GET['dat1'],$_GET['dat2'],$_GET['dat3'],$_GET['dat4'],$_GET['lim'],$_GET['alm_id'],$_GET['mar']);
	
	$num_rows= mysqli_num_rows($dts1);
	
	
	while($dt1 = mysqli_fetch_array($dts1)){
		
		$stock=$dt1['tb_stock_num'];
		$emp_fac=$dt1['tb_empaque_fac'];
									
									
									$dtspre = $oPreciogestion->mostrar_precioxpuntoventa($dt1['tb_catalogo_id'],$dt1['tb_puntoventa_id']);		
									$numrowspre = mysqli_num_rows($dtspre);
									
									$dtp = mysqli_fetch_array($dtspre);
									$prevenf = $dtp['tb_precioproducto_prevenf'];
									$preven = $dtp['tb_precioproducto_preven'];
									$precos = $dtp['tb_precioproducto_precom'];
									$preproesp_id = $dtp['tb_precioproducto_id'];
									
									$precosuni = $precos / $emp_fac;						
						if($stock>0){
									
									$valorizado_cos = $precosuni * $stock;			
									
	$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, $dt1['tb_producto_nom'])
    ->setCellValue('B'.$c, $dt1['tb_marca_nom'])    
    ->setCellValue('C'.$c, $dt1['tb_empaque_nom'])
    ->setCellValue('D'.$c, formato_money($precosuni))
    ->setCellValue('E'.$c, $stock)
	->setCellValue('F'.$c, formato_money($valorizado_cos));
	
    $c++;
	
	$total_costo += $precosuni;
	$total_val_costo += $valorizado_cos;
	$total_stock += $stock;
								
	}}
		
	mysqli_free_result($dts1);
	
	
	
	$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, '')
    ->setCellValue('B'.$c, '')    
    ->setCellValue('C'.$c, '')
    ->setCellValue('D'.$c, formato_money($total_costo))
    ->setCellValue('E'.$c, $total_stock)
	->setCellValue('F'.$c, formato_money($total_val_costo));
	
		
	
for($z = 'A'; $z <= 'L'; $z++){
  $objPHPExcel->getActiveSheet()->getColumnDimension($z)->setAutoSize(TRUE);
}
	
	$objPHPExcel->getActiveSheet()->setTitle('REPORTE DE STOCK VALORIZADO');
	
	$nombre_archivo="REPORTE DE STOCK VALORIZADO ".date('d-m-Y H-i:s');
// Redirect output to a client’s web browser (Excel5)
//header('Content-Type: application/vnd.ms-excel');
//header('Content-Disposition: attachment;filename="'.$nombre_archivo.'.xls"');
// Redirect output to a client’s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="'.$nombre_archivo.'.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');
// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.date('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0
//$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');
exit;
?>