<?php
if (PHP_SAPI == 'cli')
  die('Se visualiza solamente desde un navegador.');
require_once dirname(__FILE__) . '/../../libreriasphp/phpexcel/Classes/PHPExcel.php';
date_default_timezone_set('America/Lima');
session_start();
require_once ("../../config/Cado.php");
require_once ("../gestionxstock/cGestionxstock.php");
$oGestionxstock = new cGestionxstock();

$fec = date('Y-m-d');
require_once ("../formatos/formato.php");
require_once ("../formatos/fechas.php");
// Create new PHPExcel object
$objPHPExcel = new PHPExcel();
// Set document properties
$objPHPExcel->getProperties()->setCreator("https://infosisperu.com")
->setLastModifiedBy("https://infosisperu.com")
->setTitle("REPORTE GESTION X STOCK")
->setSubject("Reporte")
->setDescription("Reporte generado por https://infosisperu.com")
->setKeywords("")
->setCategory("reporte excel");
$objPHPExcel->setActiveSheetIndex(0);
$c=1;
$estiloTituloColumnas = array(
  'font' => array(
    'name'  => 'Arial',
    'bold'  => true,
    'size'  =>8,
    'color' => array(
      'rgb' => '000000'
      )
    ),
  'fill' => array(
    'type'  => PHPExcel_Style_Fill::FILL_SOLID,
    'color' => array(
      'rgb' => 'FAFAFA')
    ),
  'borders' => array(
    'outline' => array(
      'style' => PHPExcel_Style_Border::BORDER_THIN ,
      'color' => array(
        'rgb' => '143860'
        )
      )
    ),
  'alignment' =>  array(
    'horizontal'=> PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    'vertical'  => PHPExcel_Style_Alignment::VERTICAL_CENTER,
    'wrap'      => TRUE
    )
  );
  
  $estiloTitulos = array(
  'font' => array(
    'name'  => 'Arial',
    'bold'  => true,
    'size'  =>8,
    'color' => array(
      'rgb' => 'FFFFFF'
      )
    ),
  'fill' => array(
    'type'  => PHPExcel_Style_Fill::FILL_SOLID,
    'color' => array(
      'rgb' => 'FF8800')
    ),
  'borders' => array(
    'outline' => array(
      'style' => PHPExcel_Style_Border::BORDER_THIN ,
      'color' => array(
        'rgb' => '143860'
        )
      )
    ),
  'alignment' =>  array(
    'horizontal'=> PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    'vertical'  => PHPExcel_Style_Alignment::VERTICAL_CENTER,
    'wrap'      => TRUE
    )
  );
  
  $estiloTotales = array(
  'font' => array(
    'name'  => 'Arial',
    'bold'  => true,
    'size'  =>8,
    'color' => array(
      'rgb' => 'FFFFFF'
      )
    ),
  'fill' => array(
    'type'  => PHPExcel_Style_Fill::FILL_SOLID,
    'color' => array(
      'rgb' => '0d47a1')
    ),
  'borders' => array(
    'outline' => array(
      'style' => PHPExcel_Style_Border::BORDER_THIN ,
      'color' => array(
        'rgb' => '143860'
        )
      )
    ),
  'alignment' =>  array(
    'horizontal'=> PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    'vertical'  => PHPExcel_Style_Alignment::VERTICAL_CENTER,
    'wrap'      => TRUE
    )
  );
  
  $titulos = array(
  'COD. INT.',
  'NOMBRE',
  'LABORATORIO',
  'CATEGORIA',
  'PRESENTACION', 
  'EMPAQUE', 
  'FEC. VENCIMIENTO', 
  'STOCK ACTUAL'
  );
  
  $letras = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');
  
	$objPHPExcel->getActiveSheet()->setCellValue("A$c", 'REPORTE DE PRODUCTOS POR STOCK');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:G$c")->applyFromArray($estiloTitulos);
	
	$c = $c+1;
  
  $letracolumn = 0;
  
  //// COMPRAS
  for ($i=0; $i < count($titulos) ; $i++) { 
    $letracolumn = $i;
    $objPHPExcel->getActiveSheet()->setCellValue($letras[$i].$c, $titulos[$i]);
  }
  $objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->applyFromArray($estiloTituloColumnas);
		$c = $c+1;
 
	$dtc1 = $oGestionxstock->filtrar($_GET['dat1'],$_GET['dat2'],$_GET['dat3'],$_GET['dat4'],'',$_GET['alm_id'],$_GET['mar'],$_GET['acc'],$_GET['cat_id']);
	
	while($dt = mysqli_fetch_array($dtc1)){
		
		$stock = $dt['tb_stock_num']*1; 
		$emp_fac = $dt['tb_empaque_fac'];
							$can = $stock / $emp_fac;
							$canf = 0;
							$cane = 0;
							//echo $emp_fac.'--';
							if($stock<$emp_fac){
								$cane = $cane;
								$canf = $stock;
							}else{
								list($cane,$canf) = explode('.',$can);
							}
							
							
							if($cane>0 && $canf>0){
								$canemp = $cane * $emp_fac;
								$canf = $stock - $canemp;
								$stock = $cane.'F'.$canf;
							}else if($cane>0 && $canf==""){
								$stock = $cane;
							}else if($cane=="" && $canf>0){
								
								$stock = 'F'.$canf;
							}
		
	$objPHPExcel->getActiveSheet(0)
	->setCellValue('A'.$c, $dt['tb_producto_codint'])
    ->setCellValue('B'.$c, $dt['tb_producto_nom'])
    ->setCellValue('C'.$c, $dt['tb_marca_nom'])    
    ->setCellValue('D'.$c, $dt['tb_categoria_nom'])
    ->setCellValue('E'.$c, $dt['tb_presentacion_nom'])
    ->setCellValue('F'.$c, $dt['tb_empaque_nom'])
    ->setCellValue('G'.$c, mostrarFecha($dt['tb_productomarca_fecven']))
    ->setCellValue('H'.$c, $stock);
	
    $c++;
	
	}
		
	mysqli_free_result($dtc1);
		
	
for($z = 'A'; $z <= 'L'; $z++){
  $objPHPExcel->getActiveSheet()->getColumnDimension($z)->setAutoSize(TRUE);
}
	
	$objPHPExcel->getActiveSheet()->setTitle('REPORTE DE PRODUCTOS POR STOCK');
	
	$nombre_archivo="REPORTE DE PRODUCTOS POR STOCK ".date('d-m-Y H-i:s');
// Redirect output to a client’s web browser (Excel5)
//header('Content-Type: application/vnd.ms-excel');
//header('Content-Disposition: attachment;filename="'.$nombre_archivo.'.xls"');
// Redirect output to a client’s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="'.$nombre_archivo.'.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');
// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.date('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0
//$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');
exit;
?>